/* digital pins */
const int recButton = 12;
const int presetButton = 2;
const int sonar1 = 6;
const int sonar2 = 7;
const int led = 4;
/* analog pins */
const int temp1 = 0; 
const int temp2 = 1; 
const int temp3 = 2; 
const int temp4 = 3;
const int lux1 = 4;
const int lux2 = 5;
long pulse1 = 0;
long pulse2 = 0;
int rec = 0;
int preset = 0;
float maxLux1 = 1024;
float maxLux2 = 1024;
float minTemp1 = 1024;
float minTemp2 = 1024;
float minTemp3 = 1024;
float minTemp4 = 1024;
float maxSonar1 = 1024;
float maxSonar2 = 1024;
float maxSonar1Cm = 42;
float maxSonar2Cm = 42;
void setup() {
  Serial.begin(9600);
  pinMode(sonar1, INPUT);
  pinMode(sonar2, INPUT);
  pinMode(recButton, INPUT);
  pinMode(presetButton, INPUT);
  pinMode(led, OUTPUT);
}
void loop() {
  
  /* gestion de la LED */
  /* pendant calibration, clignotement */
  if(rec > 0){
    if(rec % 3 == 1){
      digitalWrite(led, HIGH);
    }
    else{
      digitalWrite(led, LOW);
    }
  }
  else{
    /* si le bouton de preset est actif, extinction */
    if(digitalRead(presetButton) == HIGH){
      digitalWrite(led, LOW);
    }
    /* sinon, LED alumee */
    else{
      digitalWrite(led, HIGH);
    }
  }
  
  
  /* on lit les entrees des sonars */
  pulse1 = pulseIn(sonar1, HIGH);
  pulse2 = pulseIn(sonar2, HIGH);
  
  /* si le bouton de calibrage est actif */
  if(digitalRead(recButton) == HIGH){
    maxSonar1 = 0;
    maxSonar2 = 0;
    maxLux1 = 1024;
    maxLux2 = 1024;
    minTemp1 = 0;
    minTemp2 = 0;
    minTemp3 = 0;
    minTemp4 = 0;
    rec = 50; /* nombre de pas de calibration */
  }
  /* si on appuie sur le bouton de preset */
  if(digitalRead(presetButton) == HIGH){
      preset = 1;
  }else{
      preset = 0;    
  }
  
  /* pendant la calibration */
  if(rec > 0){
    if(pulse1 > maxSonar1){
      maxSonar1 = pulse1;
    }
    if(pulse2 > maxSonar2){
      maxSonar2 = pulse2;
    }
    if(analogRead(lux1) < maxLux1){
      maxLux1 = analogRead(lux1);
    }
    if(analogRead(lux2) < maxLux2){
      maxLux2= analogRead(lux2); 
    }
    if(analogRead(temp1) > minTemp1){
      minTemp1 = analogRead(temp1);
    }
    if(analogRead(temp2) > minTemp2){
      minTemp2 = analogRead(temp2);
    }
    if(analogRead(temp3) > minTemp3){
      minTemp3 = analogRead(temp3);
    }
    if(analogRead(temp4) > minTemp4){
      minTemp4 = analogRead(temp4);
    }
    maxSonar1Cm = (maxSonar1 / 147) * 2.54;
    maxSonar2Cm = (maxSonar2 / 147) * 2.54;
    rec = rec - 1;
  }
  
  /* envoi des donnees */
  pulse1 = (pulse1 / 147) * 2.54;
  int send_sonar1 = int((pulse1 / maxSonar1Cm) * 800);  
  if (send_sonar1 > 800){
    send_sonar1 = 800;
  }else if (send_sonar1 < 0){
    send_sonar1 = 0;
  }
  Serial.print(send_sonar1);
  Serial.print("*");
  
  pulse2 = (pulse2 / 147) * 2.54;
  int send_sonar2 = int((pulse2 / maxSonar2Cm) * 800);
  if (send_sonar2 > 800){
    send_sonar2 = 800;
  }else if (send_sonar2 < 0){
    send_sonar2 = 0;
  }
  Serial.print(send_sonar2);
  Serial.print("*");
  
  int send_temp1 = int(((analogRead(temp1) - (minTemp1 - 100)) / 100) * 1024);
  if(send_temp1 > 1024){
    send_temp1 = 1024;
  }
  else if(send_temp1 < 0){
    send_temp1 = 0;
  }
  Serial.print(send_temp1);
  Serial.print("*");
  
  int send_temp2 = int(((analogRead(temp2) - (minTemp2 - 100)) / 100) * 1024);
  if(send_temp2 > 1024){
    send_temp2 = 1024;
  }
  else if(send_temp2 < 0){
    send_temp2 = 0;
  }
  Serial.print(send_temp2);
  Serial.print("*");
  
  int send_temp3 = int(((analogRead(temp3) - (minTemp3 - 100)) / 100) * 1024);
  if(send_temp3 > 1024){
    send_temp3 = 1024;
  }
  else if(send_temp3 < 0){
    send_temp3 = 0;
  }
  Serial.print(send_temp3);
  Serial.print("*");
  
  int send_temp4 = int(((analogRead(temp4) - (minTemp4 - 100)) / 100) * 1024);
  if(send_temp4 > 1024){
    send_temp4 = 1024;
  }
  else if(send_temp4 < 0){
    send_temp4 = 0;
  }
  Serial.print(send_temp4);
  Serial.print("*"); 
  
  int send_lux1 = int(((1024 - analogRead(lux1)) / (1024 - maxLux1)) * 1024);
  if(send_lux1 > 1024){
    send_lux1 = 1024;
  }
  else if(send_lux1 < 0){
    send_lux1 = 0;
  }
  Serial.print(send_lux1);
  Serial.print("*");
  
  int send_lux2 = int(((1024 - analogRead(lux2)) / (1024 - maxLux2)) * 1024);
  if(send_lux2 > 1024){
    send_lux2 = 1024;
  }
  else if(send_lux2 < 0){
    send_lux2 = 0;
  }
  Serial.print(send_lux2);
  Serial.print("*");
  
  Serial.print(preset);
  Serial.print("*");
  
  Serial.print("/");
  delay(100);
}
